<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Cviebrock\EloquentSluggable\Services\SlugService;
use Illuminate\Database\QueryException;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Str;
use App\Models\ServiceFeeStructure;
use App\Models\UserReview;
use App\Models\Appointments;
use Illuminate\Support\Facades\Http;
use App\Models\PushNotification;
use Razorpay\Api\Api;
use Carbon\Carbon;
use App\Models\WalletPoint;
use App\Models\WalletPointCommission;
use App\Models\PaymentDetails;
use App\Models\UserWalletTransactions;
use App\Models\UserWallet;
use App\Models\TypesOfWallet;
use App\Imports\UsersImport;
use App\Imports\LocationImport;
use Maatwebsite\Excel\Facades\Excel;
use Mgcodeur\CurrencyConverter\Facades\CurrencyConverter;

class UserController extends Controller
{
    public function saveUser(Request $request)
    {

        $phone = User::where("Phone", $request->phone)->first();
        if (!empty($phone)) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => "Phone Number Already Exist"
                ),
                200
            );
        }
        $email = User::where("Email", $request->email)->first();
        if (!empty($email)) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => "Email Already Exist"
                ),
                200
            );
        }
        try {
            $request->validate([
                'first_name' => 'required',
                'last_name' => 'required',
                'email' => 'required',
                'phone' => 'required'
            ]);

            $name = $request->first_name . ' ' . $request->last_name;
            $slug = SlugService::createSlug(
                User::class,
                'slug',
                $name
            );
            $pn = 'P' . random_int(000000000000000000, 999999999999999999);
            $userid = random_int(400000, 499999);

            $user = new User();
            $user->UserId = $userid;
            $user->Patient_Identification_Number = $pn;
            $user->First_Name = $request->first_name;
            $user->Last_Name = $request->last_name;
            $user->slug = $slug;
            $user->Email = $request->email;
            $user->Phone_Code = $request->code;
            $user->phone = $request->phone;
            $user->SMS = $request->code . '-' . $request->phone;
            $user->Gender = $request->gender;
            $user->DOB = date("Y-m-d", strtotime($request->dob));
            $user->save();

            if ($user) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "User Added Successfully"
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong"
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
            // return $e->getMessage();
        }
    }

    public function updateUser(Request $request)
    {

        try {
            // ******** Image uploade start ********
            if ($request->hasFile('image')) {
                if ($request->hasFile('image')) {
                    $rand = rand(100, 999);
                    $image = time() . '.' . $request->image->extension();
                    $imageOriginalName = $request->image->getClientOriginalName();
                    $request->image->move(public_path('assets/uploads/user'), $image);
                }
                $resimage = User::where('id', $request->id)
                    ->update([
                        'image' => $image
                    ]);
            }
            // ******** Image uploade end ********
            $data = User::where('id', $request->id)->first();
            $name = $request->first_name . ' ' . $request->last_name;
            if ($request->title != $data->title) {
                $slug = SlugService::createSlug(User::class, 'slug', $name);
            } else {
                $slug = $data->slug;
            }

            $res = User::where('id', $request->id)
                ->update([
                    'First_Name' => $request->first_name,
                    'Last_Name' => $request->last_name,
                    'Email' => $request->email,
                    'Phone_Code' => $request->code,
                    'phone' => $request->phone,
                    'sms' => $request->code . '-' . $request->phone,
                    'Gender' => $request->gender,
                    'alternative_email' => $request->alternative_email,
                    'alternative_phone' => $request->alternative_phone,
                    'DOB' =>  date("Y-m-d", strtotime($request->dob))
                ]);

            if ($res == 1 || $resimage == 1) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Data updated successfully"
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went wrong"
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }
    public function getUser(Request $request)
    {
        if ($request->ajax()) {
            $data = User::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                // ->addIndexColumn()
                ->addColumn('pid', function ($data) {
                    return  '<a href="' . route('admin.view-user', ['slug' => $data->id]) . '" >' . $data->Patient_Identification_Number . '</a>';
                })
                ->addColumn('action', function ($data) {
                    $actionBtn = '<a href="' . route('admin.view-user', ['slug' => $data->id]) . '"  class="text-muted"> <span class="badge badge-primary"><i class="far fa-eye"></i></span></a>
                     <a href="' . route('admin.edit-user', ['slug' => $data->id]) . '"   class="text-muted" > <span class="badge badge-success"><i class="far fa-edit"></i></span></a>
                                            <a  href="javascript:void(0);" data-id="' . $data->id . '"  id="getDeleteId" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_user"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                // ->addColumn('p_number', function ($data) {
                //     return   $data->Patient_Identification_Number;
                // })
                ->addColumn('name', function ($data) {
                    // return   $data->title;
                    if ($data->image != NULL) {
                        $img = asset('assets/uploads/user/' . $data->image);
                    } else {
                        $img = asset('assets/img/no-image-available.jpg');
                    }
                    $html = '<a href="' . route('admin.view-user', ['slug' => $data->id]) . '" ><div class="chat-user-group d-flex align-items-center">
                        <div class="img-users call-user">
                        <img src="' . $img . '" alt="img">
                        </div>
                        <div class="chat-users chat-user-blk">
                        <div class="user-titles ">
                        <h5> ' . $data->First_Name . '  ' . $data->Last_Name . '</h5>
                        </div>
                        </div></a>
';
                    return $html;
                })
                ->addColumn('phone', function ($data) {
                    return   $data->Phone_Code . '-' . $data->phone;
                })
                ->addColumn('email', function ($data) {
                    return   $data->Email;
                })
                ->addColumn('status', function ($data) {
                    $status = '';
                    $class = '';
                    if ($data->status == 'ACTIVE') {
                        $class = "success";
                        $val = 'BLOCKED';
                    } else {
                        $class = "danger";
                        $val = 'ACTIVE';
                    }
                    return '<a href="javascript:void(0)" data-id="' . $data->id . '" data-value="' . $val . '" id="status"><span class="badge badge-' . $class . '">' . $data->status . '</span></a>';
                })
                ->editColumn('checkbox', static function ($data) {
                    return '<input type="checkbox" name="datatablecheckbox[]" class="datatablecheckbox" value="' . $data->id . '"/>';
                })->rawColumns(['checkbox'])

                ->escapeColumns([])

                ->make(true);
        }
    }

    public function changeUserStatus(Request $request)
    {
        $res = User::where('id', $request->id)
            ->update(['status' => $request->status]);
        return $res;
    }

    public function deleteUser(Request $request)
    {
        try {
            $data = User::where('id', $request->id)->first();

            if ((file_exists(public_path('assets/uploads/user/' . $data->image))) && ($data->image != NULL)) {
                unlink("assets/uploads/user/" . $data->image);
            }

            $res = User::where('id', $request->id)->delete();
            return $res;
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }

    public function editUser(Request $request)
    {
        $data = User::where('id', $request->slug)->first();
        return view('admin.user.edit', ['data' => $data]);
    }

    public function viewUser(Request $request)
    {


        // die();
        $convertedAmount = CurrencyConverter::convert(1)
            ->from('USD')
            ->to('INR')
            ->get();

        echo "1 USD -> INR =" . round($convertedAmount, 2) . " (original price: 83.61)";
        echo "<br>";

        echo "<br>";
        $convertedAmount = CurrencyConverter::convert(1)
            ->from('AED')
            ->to('INR')
            ->get();

        echo "1 AED -> INR =" . round($convertedAmount, 2) . " (original price: 22.77)";
        echo "<br>";
        echo "<br>";

        $convertedAmount = CurrencyConverter::convert(1)
            ->from('MXN')
            ->to('INR')
            ->get();

        echo "1 MXN -> INR =" . round($convertedAmount, 2) . " (original price: 4.56)";
        echo "<br>";
        echo "<br>";

        $convertedAmount = CurrencyConverter::convert(1)
            ->from('GBP')
            ->to('INR')
            ->get();
        // die();
        echo "1 GBP -> INR =" . round($convertedAmount, 2) . " (original price: 105.85)";
        echo "<br>";
        echo "<br>";
        die();
        $user = User::where('id', $request->slug)->first();
        return view('admin.user.view', ['user' => $user]);
    }

    public function deleteMultipleUser(Request $request)
    {

        $ids = $request->ids;

        foreach ($ids as $id) {
            $data = User::whereRaw('id = ?', $id)->first();
            if (file_exists(public_path('assets/uploads/user/' . $data->image)) && ($data->image != null)) {
                unlink("assets/uploads/user/" . $data->image);
            }
        }
        $res = User::whereIn('id',  $ids)->delete();
        return $res;
    }

    public function getReviews(Request $request)
    {
        if ($request->ajax()) {
            $data = UserReview::where('user_id', $request->slug)->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '<a href="' . route('admin.view-appoinment', ['id' => $data->appoinment_id]) . '"  class="text-muted"> <span class="badge badge-primary"><i class="far fa-eye"></i></span></a>
                    ';
                    return $actionBtn;
                })
                ->addColumn('therapist', function ($data) {
                    $html = '  <a href="' . route('admin.view-therapist', ['slug' => $data->therapist->slug]) . '"><img width="28" height="28" src="' . asset('assets/uploads/therapist/') . '/' . $data->therapist->image . '" class="rounded-circle m-r-5" alt> ' . $data->therapist->full_name . '</a>';

                    return   $html;
                })
                ->addColumn('comment', function ($data) {
                    return $data->comment;
                })
                ->addColumn('star', function ($data) {
                    $html = '';
                    for ($i = 0; $i < $data->rate; $i++) {
                        $html .= ' <i class="fa-solid fa-star m-r-5 status-orange"></i>';
                    }
                    if ($data->rate < 5) {
                        $bal = 5 - $data->rate;
                        for ($i = 0; $i < $bal; $i++) {
                            $html .= ' <i class="fa-solid fa-star m-r-5"></i>';
                        }
                    }
                    return $html;
                })
                ->addColumn('postdate', function ($data) {
                    return   $data->created_at;
                })

                ->escapeColumns([])

                ->make(true);
        }
    }

    public function getReviewsTherapist(Request $request)
    {
        if ($request->ajax()) {
            $data = UserReview::where('therapist_id', $request->id)->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '<a href="' . route('admin.view-appoinment', ['id' => $data->appoinment_id]) . '"  class="text-muted"> <span class="badge badge-primary"><i class="far fa-eye"></i></span></a>
                    ';
                    return $actionBtn;
                })
                ->addColumn('user', function ($data) {
                    $html = '  <a href="' . route('admin.view-user', ['slug' => $data->user->id]) . '" ><img width="28" height="28" src="' . asset('assets/uploads/user/') . '/' . $data->user->image . '" class="rounded-circle m-r-5" alt> ' . $data->user->First_Name . ' ' . $data->user->Last_Name . '</a>';

                    return   $html;
                })
                ->addColumn('comment', function ($data) {
                    return $data->comment;
                })
                ->addColumn('star', function ($data) {
                    $html = '';
                    for ($i = 0; $i < $data->rate; $i++) {
                        $html .= ' <i class="fa-solid fa-star m-r-5 status-orange"></i>';
                    }
                    if ($data->rate < 5) {
                        $bal = 5 - $data->rate;
                        for ($i = 0; $i < $bal; $i++) {
                            $html .= ' <i class="fa-solid fa-star m-r-5"></i>';
                        }
                    }
                    return $html;
                })
                ->addColumn('postdate', function ($data) {
                    return   $data->created_at;
                })

                ->escapeColumns([])

                ->make(true);
        }
    }

    public function import()
    {
        // Excel::import(new UsersImport, request()->file('file'));
        Excel::import(new LocationImport, request()->file('file'));
        return back();
    }
}
